/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.cplgfmdk;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaServices;
import com.ibm.hwmca.fw.mediasvc.NoMediaPresentException;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.task.HwmcaPanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.TaskActionEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class CopyLogFromDisketteTasklet
extends HwmcaPanelTasklet {
    private static final String TRACE_MASKT = "HCPFTSKT";
    private static final String TRACE_MASKF = "HCPFTSKF";
    private static final String TRACE_MASKD = "HCPFTSKD";
    private static final int ZIP_BLOCK_SIZE = 2048;
    private static final int MAX_BYTES_ON_FLOPPY = 1422998;
    private static final int EXTRA_BYTES_ON_FLOPPY = 2;
    private static final String LOG_DEST_NAME = "logdest";
    private static final String ROOT_DIRECTORY = "/mnt/floppy/";

    public void logException(Throwable throwable) {
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, ">> service: ");
        if (request.isInitialRequest()) {
            try {
                String destPath = BaseFileControl.getFilePath(LOG_DEST_NAME);
                Trace.trace(TRACE_MASKT, "filePath " + destPath);
                File zippedFile = this.readFilesFromFloppy();
                if (zippedFile != null) {
                    File originalFile = this.expandFile(zippedFile, destPath);
                    zippedFile.delete();
                    if (originalFile != null) {
                        BaseMessageText msgText = new BaseMessageText("HCPF0007", new String[]{originalFile.getName(), destPath});
                        BaseMessageTitle msgTitle = new BaseMessageTitle("HCPFTIFR");
                        this.showMessageBox(true, msgTitle, msgText, MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                    }
                }
            }
            catch (HException e) {
                Trace.trace(TRACE_MASKT, "compressFile exception: " + e);
            }
            response.terminate();
        } else if (request.isDisposed()) {
            response.terminate();
        } else {
            TaskActionEvent event = (TaskActionEvent)request.getData("event");
            if (event == null) {
                String eventname = (String)request.getData("menuevent");
            } else {
                String eventname = event.getElementName();
            }
            Trace.trace(TRACE_MASKT, "<< service: ");
            response.noAction();
        }
    }

    public File readFilesFromFloppy() {
        Trace.trace(TRACE_MASKT, ">> readFilesFromFloppy:");
        boolean bytesRead = false;
        Object buffer = null;
        File tempZipFile = null;
        MediaServices mediaServices = null;
        MediaDeviceIdentifier mediaIdentifier = null;
        MediaDevice mediaDevice = null;
        try {
            boolean retry = false;
            boolean userCanceled = false;
            LocalizableText name = new LocalizableText("CPY");
            mediaServices = MediaServices.getMediaServices();
            mediaIdentifier = mediaServices.getPreferredDevice(1);
            mediaDevice = mediaServices.requestLock(name, mediaIdentifier);
            BaseMessageText msgText = new BaseMessageText("HCPF0002");
            BaseMessageTitle msgTitle = new BaseMessageTitle("HCPFTIFR");
            retry = true;
            while (retry) {
                mediaDevice.unmount();
                LocalizableText ans = this.showMessageBox(true, msgTitle, msgText, MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON, CommonMsgInterface.CANCEL_BUTTON});
                if (ans.equals(CommonMsgInterface.CANCEL_BUTTON)) {
                    retry = false;
                    userCanceled = true;
                }
                if (userCanceled) continue;
                try {
                    mediaDevice.mountReadOnly();
                    retry = false;
                    if (this.getDiskNumber(mediaDevice) == 1) continue;
                    Trace.trace(TRACE_MASKT, "readFilesFromFloppy: wrong disk");
                    msgText = new BaseMessageText("HCPF0003", new String[]{"1"});
                    retry = true;
                }
                catch (NoMediaPresentException ex) {
                    Trace.trace(TRACE_MASKT, "compressFile: No disk in drive");
                    msgText = new BaseMessageText("HCPF0004", new String[]{"1"});
                    retry = true;
                }
                catch (MediaDeviceException ex) {
                    Trace.trace(TRACE_MASKT, "copyFilesToFloppy: bad disk");
                    msgText = new BaseMessageText("HCPF0008");
                    retry = true;
                }
            }
            if (!userCanceled) {
                int totFiles = this.getNumberOfDisks(mediaDevice);
                File aDisk = new File(ROOT_DIRECTORY);
                File[] aDiskFiles = aDisk.listFiles();
                File inputFile = aDiskFiles[0];
                tempZipFile = File.createTempFile(inputFile.getName(), "zip");
                tempZipFile.deleteOnExit();
                FileOutputStream outputStream = new FileOutputStream(tempZipFile);
                BufferedOutputStream bufOutputStream = new BufferedOutputStream(outputStream);
                int i = 0;
                while (i < totFiles) {
                    msgText = new BaseMessageText("HCPF0005", new String[]{new Integer(i + 1).toString(), new Integer(totFiles).toString()});
                    retry = true;
                    while (retry) {
                        LocalizableText ans;
                        mediaDevice.unmount();
                        if (i > 0 && (ans = this.showMessageBox(true, msgTitle, msgText, MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON, CommonMsgInterface.CANCEL_BUTTON})).equals(CommonMsgInterface.CANCEL_BUTTON)) {
                            mediaDevice.unlock();
                            retry = false;
                            userCanceled = true;
                        }
                        if (userCanceled) continue;
                        try {
                            mediaDevice.mountReadOnly();
                            retry = false;
                            if (this.getDiskNumber(mediaDevice) == i + 1) continue;
                            Trace.trace(TRACE_MASKT, "readFilesFromFloppy: wrong disk #");
                            msgText = new BaseMessageText("HCPF0003", new String[]{new Integer(i + 1).toString()});
                            retry = true;
                        }
                        catch (NoMediaPresentException ex) {
                            Trace.trace(TRACE_MASKT, "compressFile: No disk in drive");
                            msgText = new BaseMessageText("HCPF0004", new String[]{new Integer(i + 1).toString()});
                            retry = true;
                        }
                        catch (MediaDeviceException ex) {
                            Trace.trace(TRACE_MASKT, "copyFilesToFloppy: bad disk");
                            msgText = new BaseMessageText("HCPF0008");
                            retry = true;
                        }
                    }
                    if (userCanceled) {
                        tempZipFile = null;
                        break;
                    }
                    this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "cplgfmdk.busy.title"), new LocalizableText(BaseTextBundle.getBundleName(), "cplgrest.busy.text", new String[]{new Integer(i + 1).toString(), new Integer(totFiles).toString()}));
                    aDisk = new File(ROOT_DIRECTORY);
                    aDiskFiles = aDisk.listFiles();
                    inputFile = aDiskFiles[0];
                    byte[] data = new byte[(int)inputFile.length() - 2];
                    FileInputStream inputStream = new FileInputStream(inputFile);
                    BufferedInputStream bufInputStream = new BufferedInputStream(inputStream, (int)inputFile.length() - 2);
                    int count = bufInputStream.read(data, 0, (int)inputFile.length() - 2);
                    Trace.trace(TRACE_MASKT, "Read " + count + " bytes from disk #" + (i + 1));
                    bufOutputStream.write(data);
                    bufInputStream.close();
                    this.destroyBusyDialog();
                    ++i;
                }
                bufOutputStream.flush();
                bufOutputStream.close();
            }
        }
        catch (MediaDeviceException e) {
            Trace.trace(TRACE_MASKT, "copyFilesToFloppy exception: " + e);
            try {
                LocalizableText ans = this.showMessageBox(true, new BaseMessageTitle("HCPFTIFR"), new BaseMessageText("HCPF0008"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
            }
            catch (Exception ex) {
                // empty catch block
            }
            tempZipFile = null;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "readFilesFromFloppy exception: " + e);
            tempZipFile = null;
        }
        Trace.trace(TRACE_MASKT, "<< readFilesFromFloppy:");
        try {
            mediaDevice.unlock();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "readFilesFromFloppy unlock exception: " + e);
        }
        return tempZipFile;
    }

    public int getDiskNumber(MediaDevice mediaDevice) {
        Trace.trace(TRACE_MASKT, ">> getDiskNumber: ");
        byte[] buffer = null;
        int retvalue = -1;
        try {
            File aDisk = new File(ROOT_DIRECTORY);
            File[] aDiskFiles = aDisk.listFiles();
            File inputFile = aDiskFiles[0];
            RandomAccessFile floppyFile = new RandomAccessFile(inputFile, "r");
            buffer = new byte[2];
            floppyFile.seek(inputFile.length() - 2L);
            int bytesRead = floppyFile.read(buffer);
            floppyFile.close();
            retvalue = buffer[0];
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "getDiskNumber exception: " + e);
        }
        Trace.trace(TRACE_MASKT, "<< getDiskNumber: ");
        return retvalue;
    }

    public int getNumberOfDisks(MediaDevice mediaDevice) {
        Trace.trace(TRACE_MASKT, ">> getNumberOfDisks: ");
        byte[] buffer = null;
        int retvalue = -1;
        try {
            File aDisk = new File(ROOT_DIRECTORY);
            File[] aDiskFiles = aDisk.listFiles();
            File inputFile = aDiskFiles[0];
            RandomAccessFile floppyFile = new RandomAccessFile(inputFile, "r");
            buffer = new byte[2];
            floppyFile.seek(inputFile.length() - 2L);
            int bytesRead = floppyFile.read(buffer);
            floppyFile.close();
            retvalue = buffer[1];
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "getNumberOfDisks exception: " + e);
        }
        Trace.trace(TRACE_MASKT, "<< getNumberOfDisks: ");
        return retvalue;
    }

    /*
     * WARNING - void declaration
     */
    public File expandFile(File inputFile, String destPath) {
        Trace.trace(TRACE_MASKT, ">> expandFile: ");
        try {
            ZipFile zipFile = new ZipFile(inputFile);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            File unZippedFile = null;
            while (enumeration.hasMoreElements()) {
                int count;
                ZipEntry zipEntry = enumeration.nextElement();
                BufferedInputStream bufInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                unZippedFile = new File(destPath + zipEntry.getName());
                FileOutputStream outputStream = new FileOutputStream(unZippedFile);
                BufferedOutputStream bufOutputStream = new BufferedOutputStream(outputStream, 2048);
                byte[] data = new byte[2048];
                while ((count = bufInputStream.read(data, 0, 2048)) != -1) {
                    void var11_12;
                    bufOutputStream.write(data, 0, (int)var11_12);
                }
                bufOutputStream.flush();
                bufOutputStream.close();
                bufInputStream.close();
            }
            Trace.trace(TRACE_MASKT, "<< expandFile: ");
            return unZippedFile;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "expandFile exception: " + e);
            return null;
        }
    }
}

